/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.util.Callback;
import org.controlsfx.control.CheckComboBox;

public class CheckComboBoxSkin<T>
extends SkinBase<CheckComboBox<T>> {
    private final ComboBox<T> comboBox;
    private final ListCell<T> buttonCell;
    private final CheckComboBox<T> control;
    private final ObservableList<T> items;
    private final ReadOnlyUnbackedObservableList<Integer> selectedIndices;
    private final ReadOnlyUnbackedObservableList<T> selectedItems;

    public CheckComboBoxSkin(final CheckComboBox<T> control) {
        super(control);
        this.control = control;
        this.items = control.getItems();
        this.selectedIndices = (ReadOnlyUnbackedObservableList)control.getCheckModel().getCheckedIndices();
        this.selectedItems = (ReadOnlyUnbackedObservableList)control.getCheckModel().getCheckedItems();
        this.comboBox = new ComboBox<T>(this.items){

            protected Skin<?> createDefaultSkin() {
                return new ComboBoxListViewSkin<T>(this){
                    {
                        this.setHideOnClick(false);
                    }
                };
            }
        };
        this.comboBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.comboBox.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> listView) {
                CheckBoxListCell result = new CheckBoxListCell(item -> control.getItemBooleanProperty(item));
                result.converterProperty().bind(control.converterProperty());
                return result;
            }
        });
        this.buttonCell = new ListCell<T>(){

            protected void updateItem(T item, boolean empty) {
                this.setText(CheckComboBoxSkin.this.buildString());
            }
        };
        this.comboBox.setButtonCell(this.buttonCell);
        this.comboBox.setValue((Object)this.buildString());
        this.selectedIndices.addListener(c -> this.buttonCell.updateIndex(0));
        this.getChildren().add(this.comboBox);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.minWidth(height);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.minHeight(width);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.prefWidth(height);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((CheckComboBox)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((CheckComboBox)this.getSkinnable()).prefHeight(width);
    }

    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        int max = this.selectedItems.size();
        for (int i = 0; i < max; ++i) {
            Object item = this.selectedItems.get(i);
            if (this.control.getConverter() == null) {
                sb.append(item);
            } else {
                sb.append(this.control.getConverter().toString(item));
            }
            if (i >= max - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

