/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.autocompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public abstract class SuggestionProvider<T>
implements Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> {
    private final List<T> possibleSuggestions = new ArrayList<T>();
    private final Object possibleSuggestionsLock = new Object();
    private final BooleanProperty showAllIfEmptyProperty = new SimpleBooleanProperty(false);

    public final BooleanProperty showAllIfEmptyProperty() {
        return this.showAllIfEmptyProperty;
    }

    public final boolean isShowAllIfEmpty() {
        return this.showAllIfEmptyProperty.get();
    }

    public final void setShowAllIfEmpty(boolean showAllIfEmpty) {
        this.showAllIfEmptyProperty.set(showAllIfEmpty);
    }

    public void addPossibleSuggestions(T ... newPossible) {
        this.addPossibleSuggestions((Collection<T>)Arrays.asList(newPossible));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleSuggestions(Collection<T> newPossible) {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.addAll(newPossible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSuggestions() {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<T> call(AutoCompletionBinding.ISuggestionRequest request) {
        ArrayList<T> suggestions = new ArrayList<T>();
        if (!request.getUserText().isEmpty()) {
            Object object = this.possibleSuggestionsLock;
            synchronized (object) {
                for (T possibleSuggestion : this.possibleSuggestions) {
                    if (!this.isMatch(possibleSuggestion, request)) continue;
                    suggestions.add(possibleSuggestion);
                }
            }
            Collections.sort(suggestions, this.getComparator());
        } else if (this.isShowAllIfEmpty()) {
            Object object = this.possibleSuggestionsLock;
            synchronized (object) {
                suggestions.addAll(this.possibleSuggestions);
            }
        }
        return suggestions;
    }

    protected abstract Comparator<T> getComparator();

    protected abstract boolean isMatch(T var1, AutoCompletionBinding.ISuggestionRequest var2);

    public static <T> SuggestionProvider<T> create(Collection<T> possibleSuggestions) {
        return SuggestionProvider.create(null, possibleSuggestions);
    }

    public static <T> SuggestionProvider<T> create(Callback<T, String> stringConverter, Collection<T> possibleSuggestions) {
        SuggestionProviderString<T> suggestionProvider = new SuggestionProviderString<T>(stringConverter);
        suggestionProvider.addPossibleSuggestions(possibleSuggestions);
        return suggestionProvider;
    }

    private static class SuggestionProviderString<T>
    extends SuggestionProvider<T> {
        private Callback<T, String> stringConverter;
        private final Comparator<T> stringComparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                String o1str = (String)stringConverter.call(o1);
                String o2str = (String)stringConverter.call(o2);
                return o1str.compareTo(o2str);
            }
        };

        public SuggestionProviderString(Callback<T, String> stringConverter) {
            this.stringConverter = stringConverter;
            if (this.stringConverter == null) {
                this.stringConverter = new Callback<T, String>(){

                    public String call(T obj) {
                        return obj != null ? obj.toString() : "";
                    }
                };
            }
        }

        @Override
        protected Comparator<T> getComparator() {
            return this.stringComparator;
        }

        @Override
        protected boolean isMatch(T suggestion, AutoCompletionBinding.ISuggestionRequest request) {
            String userTextLower = request.getUserText().toLowerCase();
            String suggestionStr = ((String)this.stringConverter.call(suggestion)).toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

