/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localization {
    public static final String KEY_PREFIX = "@@";
    private static final String LOCALE_BUNDLE_NAME = "controlsfx";
    private static Locale locale = null;
    private static Locale resourceBundleLocale = null;
    private static ResourceBundle resourceBundle = null;

    private Localization() {
    }

    public static final Locale getLocale() {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static final void setLocale(Locale newLocale) {
        locale = newLocale;
    }

    private static final synchronized ResourceBundle getLocaleBundle() {
        Locale currentLocale = Localization.getLocale();
        if (!currentLocale.equals(resourceBundleLocale)) {
            resourceBundleLocale = currentLocale;
            resourceBundle = ResourceBundle.getBundle(LOCALE_BUNDLE_NAME, resourceBundleLocale, Localization.class.getClassLoader());
        }
        return resourceBundle;
    }

    public static final String getString(String key) {
        try {
            return Localization.getLocaleBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            return String.format("<%s>", key);
        }
    }

    public static final String asKey(String text) {
        return KEY_PREFIX + text;
    }

    public static final boolean isKey(String text) {
        return text != null && text.startsWith(KEY_PREFIX);
    }

    public static String localize(String text) {
        return Localization.isKey(text) ? Localization.getString(text.substring(KEY_PREFIX.length()).trim()) : text;
    }
}

