/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.hacking.tableview.cellSpan.impl;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import net.jonathangiles.hacking.tableview.cellSpan.CellSpan;
import net.jonathangiles.hacking.tableview.cellSpan.CellSpanTableView;
import net.jonathangiles.hacking.tableview.cellSpan.SpanModel;

public class CellSpanTableRowSkin<T>
extends CellSkinBase<TableRow<T>, CellBehaviorBase<TableRow<T>>> {
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    private WeakHashMap<TableColumn, TableCell> cellsMap;
    private final List<TableCell> cells = new ArrayList<TableCell>();
    private int fullRefreshCounter = 100;
    private boolean showColumns = true;
    private boolean isDirty = false;
    private boolean updateCells = false;
    private TableView<T> tableView;
    private ListChangeListener visibleLeafColumnsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change c) {
            CellSpanTableRowSkin.this.isDirty = true;
            CellSpanTableRowSkin.this.requestLayout();
        }
    };
    private CellSpanTableView<T> cellSpanTableView;
    private SpanModel spanModel;
    private int columnCount = 0;
    private static final double DEFAULT_CELL_SIZE = 24.0;

    public static double getTableRowHeight(int index, TableRow tableRow) {
        ObservableList children;
        if (index < 0) {
            return 24.0;
        }
        Group virtualFlowSheet = (Group)tableRow.getParent();
        Parent node = tableRow.getParent().getParent().getParent();
        if (node instanceof VirtualFlow && index < (children = virtualFlowSheet.getChildren()).size()) {
            return ((Node)children.get(index)).prefHeight(tableRow.getWidth());
        }
        return 24.0;
    }

    private void hide(Node node) {
        node.setManaged(false);
        node.setVisible(false);
    }

    private void show(Node node) {
        node.setManaged(true);
        node.setVisible(true);
    }

    private SpanType getSpanType(int row, int column) {
        CellSpan cellSpan;
        int rowCount = this.tableView.getItems().size();
        int columnCount = this.tableView.getVisibleLeafColumns().size();
        SpanType[][] spanTypeArray = new SpanType[rowCount][columnCount];
        for (int _row = 0; _row < rowCount; ++_row) {
            for (int _column = 0; _column < columnCount; ++_column) {
                spanTypeArray[_row][_column] = SpanType.UNSET;
            }
        }
        if (this.spanModel == null || !this.spanModel.isCellSpanEnabled()) {
            spanTypeArray[row][column] = SpanType.NONE;
            return SpanType.NONE;
        }
        int distance = 0;
        for (int _col = column - 1; _col >= 0; --_col) {
            cellSpan = this.spanModel.getCellSpanAt(row, _col);
            if (cellSpan == null || cellSpan.getColumnSpan() <= ++distance) continue;
            spanTypeArray[row][column] = SpanType.COLUMN;
            return SpanType.COLUMN;
        }
        distance = 0;
        for (int _row = row - 1; _row >= 0; --_row) {
            cellSpan = this.spanModel.getCellSpanAt(_row, column);
            if (cellSpan == null || cellSpan.getRowSpan() <= ++distance) continue;
            spanTypeArray[row][column] = SpanType.ROW;
            return SpanType.ROW;
        }
        int rowDistance = 0;
        int columnDistance = 0;
        int _col = column - 1;
        for (int _row = row - 1; _col >= 0 && _row >= 0; --_col, --_row) {
            CellSpan cellSpan2 = this.spanModel.getCellSpanAt(_row, _col);
            if (cellSpan2 == null || cellSpan2.getRowSpan() <= ++rowDistance || cellSpan2.getColumnSpan() <= ++columnDistance) continue;
            spanTypeArray[row][column] = SpanType.BOTH;
            return SpanType.BOTH;
        }
        spanTypeArray[row][column] = SpanType.NONE;
        return SpanType.NONE;
    }

    public CellSpanTableRowSkin(TableRow<T> tableRow) {
        super(tableRow, new CellBehaviorBase(tableRow));
        ((TableRow)this.getSkinnable()).setPickOnBounds(false);
        this.tableView = tableRow.getTableView();
        this.recreateCells();
        this.updateCells(true);
        this.initBindings();
        this.registerChangeListener((ObservableValue)tableRow.itemProperty(), "ITEM");
        this.registerChangeListener((ObservableValue)tableRow.editingProperty(), "EDITING");
        this.registerChangeListener((ObservableValue)tableRow.tableViewProperty(), "TABLE_VIEW");
        if (this.tableView instanceof CellSpanTableView) {
            this.cellSpanTableView = (CellSpanTableView)this.tableView;
            this.spanModel = this.cellSpanTableView.getSpanModel();
            this.registerChangeListener((ObservableValue)this.cellSpanTableView.spanModelProperty(), "SPAN_MODEL");
        } else {
            this.cellSpanTableView = null;
        }
    }

    protected void handleControlPropertyChanged(String p) {
        if (p == "TEXT" || p == "GRAPHIC" || p == "EDITING") {
            this.updateShowColumns();
        }
        super.handleControlPropertyChanged(p);
        if (p == "ITEM") {
            this.updateCells = true;
            this.requestLayout();
            ((TableRow)this.getSkinnable()).layout();
        } else if (p == "TABLE_VIEW") {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node n = (Node)this.getChildren().get(i);
                if (!(n instanceof TableCell)) continue;
                ((TableCell)n).updateTableView(((TableRow)this.getSkinnable()).getTableView());
            }
            this.tableView = ((TableRow)this.getSkinnable()).getTableView();
            if (this.tableView instanceof CellSpanTableView) {
                this.cellSpanTableView = (CellSpanTableView)this.tableView;
                this.spanModel = this.cellSpanTableView.getSpanModel();
                this.registerChangeListener((ObservableValue)this.cellSpanTableView.spanModelProperty(), "SPAN_MODEL");
            } else {
                this.cellSpanTableView = null;
            }
        } else if (p == "SPAN_MODEL") {
            this.spanModel = ((CellSpanTableView)((TableRow)this.getSkinnable()).getTableView()).getSpanModel();
            this.requestLayout();
        }
    }

    private void updateShowColumns() {
        boolean newValue;
        boolean bl = newValue = this.isIgnoreText() && this.isIgnoreGraphic();
        if (this.showColumns == newValue) {
            return;
        }
        this.showColumns = newValue;
        this.requestLayout();
    }

    private void initBindings() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("TableRowSkin does not have a Skinnable set to a TableRow instance");
        }
        if (((TableRow)this.getSkinnable()).getTableView() == null) {
            throw new IllegalStateException("TableRow not have the TableView property set");
        }
        ObservableList visibleLeafColumns = ((TableRow)this.getSkinnable()).getTableView().getVisibleLeafColumns();
        visibleLeafColumns.addListener((ListChangeListener)new WeakListChangeListener(this.visibleLeafColumnsListener));
    }

    private void doUpdateCheck() {
        if (this.isDirty) {
            this.recreateCells();
            this.updateCells(true);
            this.isDirty = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.doUpdateCheck();
        if (this.tableView == null) {
            return;
        }
        if (this.cellsMap.isEmpty()) {
            return;
        }
        if (this.showColumns && !this.tableView.getVisibleLeafColumns().isEmpty()) {
            Insets insets = this.getInsets();
            double verticalPadding = insets.getTop() + insets.getBottom();
            double horizontalPadding = insets.getLeft() + insets.getRight();
            int row = ((TableRow)this.getSkinnable()).getIndex();
            if (row < 0 || row >= this.tableView.getItems().size()) {
                return;
            }
            block4: for (int column = 0; column < this.getChildren().size(); ++column) {
                Node node = (Node)this.getChildren().get(column);
                this.show(node);
                double width = this.snapSize(node.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
                double height = Math.max(this.getHeight(), node.prefHeight(-1.0));
                height = this.snapSize(height) - this.snapSize(verticalPadding);
                if (this.spanModel != null && this.spanModel.isCellSpanEnabled()) {
                    SpanType spanType = this.getSpanType(row, column);
                    switch (spanType) {
                        case ROW: 
                        case BOTH: {
                            x += width;
                        }
                        case COLUMN: {
                            this.hide(node);
                            node.resize(0.0, 0.0);
                            node.relocate(x, insets.getTop());
                            continue block4;
                        }
                        default: {
                            int i;
                            CellSpan cellSpan = this.spanModel.getCellSpanAt(row, column);
                            if (cellSpan == null) break;
                            if (cellSpan.getColumnSpan() > 1) {
                                int colSpan = cellSpan.getColumnSpan();
                                int max = this.getChildren().size() - column;
                                for (i = 1; i < colSpan && i < max; ++i) {
                                    Node adjacentNode = (Node)this.getChildren().get(column + i);
                                    width += this.snapSize(adjacentNode.prefWidth(-1.0));
                                }
                            }
                            if (cellSpan.getRowSpan() <= 1) break;
                            for (i = 1; i < cellSpan.getRowSpan(); ++i) {
                                double rowHeight = CellSpanTableRowSkin.getTableRowHeight(row + i, (TableRow)this.getSkinnable());
                                height += this.snapSize(rowHeight);
                            }
                        }
                    }
                }
                node.resize(width, height);
                node.relocate(x, insets.getTop());
                x += width;
            }
        } else {
            super.layoutChildren(x, y, w, h);
        }
    }

    private void recreateCells() {
        TableView table = ((TableRow)this.getSkinnable()).getTableView();
        if (table == null) {
            this.clearCellsMap();
            return;
        }
        ObservableList columns = table.getVisibleLeafColumns();
        if (columns.size() != this.columnCount || this.fullRefreshCounter == 0 || this.cellsMap == null) {
            this.clearCellsMap();
            this.cellsMap = new WeakHashMap(columns.size());
            this.fullRefreshCounter = 100;
            this.getChildren().clear();
        }
        this.columnCount = columns.size();
        --this.fullRefreshCounter;
        TableRow skinnable = (TableRow)this.getSkinnable();
        for (TableColumn col : columns) {
            if (this.cellsMap.containsKey(col)) continue;
            TableCell cell = (TableCell)col.getCellFactory().call((Object)col);
            cell.updateTableColumn(col);
            cell.updateTableView(table);
            cell.updateTableRow(skinnable);
            this.cellsMap.put(col, cell);
        }
    }

    private void clearCellsMap() {
        if (this.cellsMap != null) {
            this.cellsMap.clear();
        }
    }

    private void updateCells(boolean resetChildren) {
        this.cells.clear();
        TableRow skinnable = (TableRow)this.getSkinnable();
        int skinnableIndex = skinnable.getIndex();
        TableView table = skinnable.getTableView();
        if (table != null) {
            ObservableList visibleLeafColumns = table.getVisibleLeafColumns();
            int max = visibleLeafColumns.size();
            for (int i = 0; i < max; ++i) {
                TableColumn col = (TableColumn)visibleLeafColumns.get(i);
                TableCell cell = this.cellsMap.get(col);
                if (cell == null) continue;
                cell.updateIndex(skinnableIndex);
                cell.updateTableRow(skinnable);
                this.cells.add(cell);
            }
        }
        ObservableList children = this.getChildren();
        if (resetChildren) {
            if (this.showColumns) {
                if (this.cells.isEmpty()) {
                    children.clear();
                } else {
                    children.setAll(this.cells);
                }
            } else {
                children.clear();
                if (!this.isIgnoreText() || !this.isIgnoreGraphic()) {
                    children.add((Object)skinnable);
                }
            }
        }
    }

    protected double computePrefWidth(double height) {
        this.doUpdateCheck();
        if (this.showColumns) {
            double prefWidth = 0.0;
            if (((TableRow)this.getSkinnable()).getTableView() != null) {
                ObservableList visibleLeafColumns = ((TableRow)this.getSkinnable()).getTableView().getVisibleLeafColumns();
                int max = visibleLeafColumns.size();
                for (int i = 0; i < max; ++i) {
                    TableColumn tableColumn = (TableColumn)visibleLeafColumns.get(i);
                    prefWidth += tableColumn.getWidth();
                }
            }
            return prefWidth;
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        this.doUpdateCheck();
        if (this.showColumns) {
            if (this.getCellSize() < 24.0) {
                return this.getCellSize();
            }
            double prefHeight = 0.0;
            int count = this.cells.size();
            for (int i = 0; i < count; ++i) {
                TableCell tableCell = this.cells.get(i);
                prefHeight = Math.max(prefHeight, tableCell.prefHeight(-1.0));
            }
            return Math.max(prefHeight, Math.max(this.getCellSize(), ((TableRow)this.getSkinnable()).minHeight(-1.0)));
        }
        return super.computePrefHeight(width);
    }

    private static enum SpanType {
        NONE,
        COLUMN,
        ROW,
        BOTH,
        UNSET;

    }
}

