/*
 * Decompiled with CFR 0.152.
 */
package samples.misc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Person {
    private static ObservableList<Person> testList;
    private static final boolean DEBUG = true;
    private static boolean liveUpdate;
    public static Integer MAX_HISTORY;
    private static long userIDCounter;
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String TELECOMMUTER = "telecommuter";
    public static final String BALANCE = "balance";
    private static Thread liveUpdateThread;
    private long userID;
    private final StringProperty firstNameProperty;
    private final StringProperty lastNameProperty;
    private final BooleanProperty telecommuterProperty;
    private final DoubleProperty balanceProperty;
    private final DoubleProperty progressProperty;
    private final DoubleProperty earningsProperty;
    private final ObservableList<Double> historicEarnings = FXCollections.observableArrayList(new LinkedList());
    private final ObservableList<Double> unmodifiableHistoricEarnings = FXCollections.unmodifiableObservableList(this.historicEarnings);
    private final DoubleProperty totalEarningsProperty;
    private final DoubleProperty totalSalesProperty;

    public static ObservableList<Person> getTestList() {
        return testList;
    }

    public static ObservableList<Map> getTestMap(boolean getProperty) {
        ObservableList<Person> personList = Person.getTestList();
        ObservableList personMapList = FXCollections.observableArrayList();
        for (int i = 0; i < personList.size(); ++i) {
            Person p = (Person)personList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (getProperty) {
                map.put(FIRST_NAME, p.firstNameProperty());
                map.put(LAST_NAME, p.lastNameProperty());
                map.put(TELECOMMUTER, p.telecommuterProperty());
                map.put(BALANCE, p.balanceProperty());
            } else {
                map.put(FIRST_NAME, p.getFirstName());
                map.put(LAST_NAME, p.getLastName());
                map.put(TELECOMMUTER, p.isTelecommuter());
                map.put(BALANCE, p.getBalance());
            }
            personMapList.add(map);
        }
        return personMapList;
    }

    public long getUserID() {
        return this.userID;
    }

    @XmlElement(name="userId")
    public void setUserId(long v) {
        this.userID = v;
    }

    public Person() {
        this.userID = (long)(10000.0 * Math.random());
        this.firstNameProperty = new SimpleStringProperty((Object)this, FIRST_NAME);
        this.lastNameProperty = new SimpleStringProperty((Object)this, LAST_NAME);
        this.telecommuterProperty = new SimpleBooleanProperty((Object)this, TELECOMMUTER);
        this.balanceProperty = new SimpleDoubleProperty((Object)this, BALANCE);
        this.progressProperty = new SimpleDoubleProperty((Object)this, "progress");
        this.earningsProperty = new SimpleDoubleProperty((Object)this, "earnings");
        this.totalEarningsProperty = new SimpleDoubleProperty((Object)this, "totalEarnings");
        this.totalSalesProperty = new SimpleDoubleProperty((Object)this, "totalSales");
    }

    public final StringProperty firstNameProperty() {
        return this.firstNameProperty;
    }

    public String getFirstName() {
        return (String)this.firstNameProperty.get();
    }

    public void setFirstName(String newName) {
        this.firstNameProperty.set((Object)newName);
    }

    public final StringProperty lastNameProperty() {
        return this.lastNameProperty;
    }

    public String getLastName() {
        return (String)this.lastNameProperty.get();
    }

    public void setLastName(String newName) {
        this.lastNameProperty.set((Object)newName);
    }

    public final BooleanProperty telecommuterProperty() {
        return this.telecommuterProperty;
    }

    public boolean isTelecommuter() {
        return this.telecommuterProperty.get();
    }

    public void setTelecommuter(boolean v) {
        this.telecommuterProperty().set(v);
    }

    public final DoubleProperty balanceProperty() {
        return this.balanceProperty;
    }

    public double getBalance() {
        return this.balanceProperty.get();
    }

    public final DoubleProperty progressProperty() {
        return this.progressProperty;
    }

    public double getProgress() {
        return this.progressProperty.get();
    }

    private void setProgress(double progress) {
        this.progressProperty.set(progress);
    }

    public final DoubleProperty earningsProperty() {
        return this.earningsProperty;
    }

    public double getEarnings() {
        return this.earningsProperty.get();
    }

    public void setEarnings(double earnings) {
        this.earningsProperty.set(earnings);
    }

    public final ObservableList<Double> getHistoricEarnings() {
        return this.unmodifiableHistoricEarnings;
    }

    public final DoubleProperty totalEarningsProperty() {
        return this.totalEarningsProperty;
    }

    public double getTotalEarnings() {
        return this.totalEarningsProperty.get();
    }

    private void setTotalEarnings(double earnings) {
        this.totalEarningsProperty.set(earnings);
    }

    public final DoubleProperty totalSalesProperty() {
        return this.totalSalesProperty;
    }

    public double getTotalSales() {
        return this.totalSalesProperty.get();
    }

    private void setTotalSales(double earnings) {
        this.totalSalesProperty.set(earnings);
    }

    public Person(String firstName, String lastName, boolean telecommuter) {
        this(firstName, lastName, telecommuter, 0.0);
    }

    public Person(String firstName, String lastName, boolean telecommuter, double balance) {
        this.userID = userIDCounter++;
        this.firstNameProperty = new SimpleStringProperty((Object)this, FIRST_NAME, firstName);
        this.lastNameProperty = new SimpleStringProperty((Object)this, LAST_NAME, lastName);
        this.telecommuterProperty = new SimpleBooleanProperty((Object)this, TELECOMMUTER, telecommuter);
        this.balanceProperty = new SimpleDoubleProperty((Object)this, BALANCE, balance);
        this.progressProperty = new SimpleDoubleProperty((Object)this, "progress");
        this.earningsProperty = new SimpleDoubleProperty((Object)this, "earnings");
        this.totalEarningsProperty = new SimpleDoubleProperty((Object)this, "totalEarnings");
        this.totalSalesProperty = new SimpleDoubleProperty((Object)this, "totalSales");
        this.setProgress(Math.random());
        double earnings = Math.random() * 10.0 * (double)(new Random().nextBoolean() ? 1 : -1);
        this.setEarnings(earnings);
        double sales = (double)((int)(Math.random() * 900.0 + 100.0)) / 10.0;
        this.setTotalSales(sales);
        this.earningsProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                if (Person.this.historicEarnings.size() > MAX_HISTORY) {
                    Person.this.historicEarnings.remove(0);
                }
                Person.this.historicEarnings.add((Object)((Double)newValue));
                Person.this.setTotalEarnings(Person.this.getTotalEarnings() + (Double)newValue);
            }
        });
        this.firstNameProperty.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String ov, String nv) {
                System.out.println(ov + " is renamed to : " + nv);
            }
        });
        this.telecommuterProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean ov, Boolean nv) {
                System.out.println(Person.this.getFirstName() + " is a remote worker: " + nv);
            }
        });
    }

    public static void setLiveUpdate(boolean liveUpdate) {
        Person.liveUpdate = liveUpdate;
        if (liveUpdate) {
            Person.startLiveUpdateThread();
        }
    }

    private static void startLiveUpdateThread() {
        liveUpdateThread = new Thread(new Runnable(){
            int sleep = 30;
            Random r = new Random();

            @Override
            public void run() {
                while (liveUpdate) {
                    Iterator i$ = Person.getTestList().iterator();
                    while (i$.hasNext()) {
                        Person p;
                        final Person person = p = (Person)i$.next();
                        double newProgress = (p.getProgress() + 0.025 * this.r.nextDouble()) % 1.0;
                        boolean updateEarnings = newProgress < p.getProgress();
                        p.setProgress(newProgress);
                        if (!updateEarnings) continue;
                        final double earnings = p.getEarnings() + Math.random() * 1.0 * (double)(this.r.nextBoolean() ? 1 : -1);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                person.setEarnings(earnings);
                            }
                        });
                    }
                    try {
                        Thread.sleep(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        liveUpdateThread.setDaemon(true);
        liveUpdateThread.start();
    }

    public String toString() {
        return this.getFirstName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(this.userID ^ this.userID >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        boolean answer = false;
        if (o instanceof Person) {
            Person target = (Person)o;
            answer = target.getUserID() == this.userID;
        }
        return answer;
    }

    static {
        liveUpdate = false;
        MAX_HISTORY = 10;
        userIDCounter = 1L;
        testList = FXCollections.observableArrayList((Object[])new Person[]{new Person("Jenny", "Bond", false, 23.64), new Person("Billy", "James", true, -12.11), new Person("Timmy", "Gordon", false, 45.0), new Person("Aiden", "Simpson", false, 0.0), new Person("Jacob", "Grant", true, -92.21), new Person("Jackson", "Matthews", false, 0.0), new Person("Ethan", "Beck", false, 48.12), new Person("Sophia", "Potts", true, 38.22), new Person("Isabella", "Bair", false, 823.43), new Person("Olivia", "Fowler", false, -201.23), new Person("Jayden", "Walker", true, 49.54), new Person("Emma", "Wong", false, -3.49), new Person("Chloe", "Samuelsson", false, 0.76), new Person("Logan", "Grieve", true, 49.22), new Person("Caden", "Sato", false, 90.56), new Person("Lilly", "Chin", false, -0.06), new Person("Madison", "Barbashov", true, 89.76), new Person("Ryan", "Beatty", false, 123.5), new Person("Hailey", "Giles", false, 90.56), new Person("Molly", "Vos", true, -87.12), new Person("Nolan", "Antonio", false, 992.12), new Person("Bryce", "Marinacci", false, 1832.29), new Person("Maria", "Mayhew", true, -782.12), new Person("Lauren", "Holt", false, 291.21), new Person("Jenny", "Bond", false, 23.64), new Person("Billy", "James", true, -12.11), new Person("Timmy", "Gordon", false, 45.0), new Person("Aiden", "Simpson", false, 0.0), new Person("Jacob", "Grant", true, -92.21), new Person("Jackson", "Matthews", false, 0.0), new Person("Ethan", "Beck", false, 48.12), new Person("Sophia", "Potts", true, 38.22), new Person("Isabella", "Bair", false, 823.43), new Person("Olivia", "Fowler", false, -201.23), new Person("Jayden", "Walker", true, 49.54), new Person("Emma", "Wong", false, -3.49), new Person("Chloe", "Samuelsson", false, 0.76), new Person("Logan", "Grieve", true, 49.22), new Person("Caden", "Sato", false, 90.56), new Person("Lilly", "Chin", false, -0.06), new Person("Madison", "Barbashov", true, 89.76), new Person("Ryan", "Beatty", false, 123.5), new Person("Hailey", "Giles", false, 90.56), new Person("Molly", "Vos", true, -87.12), new Person("Nolan", "Antonio", false, 992.12), new Person("Bryce", "Marinacci", false, 1832.29), new Person("Maria", "Mayhew", true, -782.12), new Person("Lauren", "Holt", false, 291.21), new Person("Jenny", "Bond", false, 23.64), new Person("Billy", "James", true, -12.11), new Person("Timmy", "Gordon", false, 45.0), new Person("Aiden", "Simpson", false, 0.0), new Person("Jacob", "Grant", true, -92.21), new Person("Jackson", "Matthews", false, 0.0), new Person("Ethan", "Beck", false, 48.12), new Person("Sophia", "Potts", true, 38.22), new Person("Isabella", "Bair", false, 823.43), new Person("Olivia", "Fowler", false, -201.23), new Person("Jayden", "Walker", true, 49.54), new Person("Emma", "Wong", false, -3.49), new Person("Chloe", "Samuelsson", false, 0.76), new Person("Logan", "Grieve", true, 49.22), new Person("Caden", "Sato", false, 90.56), new Person("Lilly", "Chin", false, -0.06), new Person("Madison", "Barbashov", true, 89.76), new Person("Ryan", "Beatty", false, 123.5), new Person("Hailey", "Giles", false, 90.56), new Person("Molly", "Vos", true, -87.12), new Person("Nolan", "Antonio", false, 992.12), new Person("Bryce", "Marinacci", false, 1832.29), new Person("Maria", "Mayhew", true, -782.12), new Person("Lauren", "Holt", false, 291.21), new Person("Jenny", "Bond", false, 23.64), new Person("Billy", "James", true, -12.11), new Person("Timmy", "Gordon", false, 45.0), new Person("Aiden", "Simpson", false, 0.0), new Person("Jacob", "Grant", true, -92.21), new Person("Jackson", "Matthews", false, 0.0), new Person("Ethan", "Beck", false, 48.12), new Person("Sophia", "Potts", true, 38.22), new Person("Isabella", "Bair", false, 823.43), new Person("Olivia", "Fowler", false, -201.23), new Person("Jayden", "Walker", true, 49.54), new Person("Emma", "Wong", false, -3.49), new Person("Chloe", "Samuelsson", false, 0.76), new Person("Logan", "Grieve", true, 49.22), new Person("Caden", "Sato", false, 90.56), new Person("Lilly", "Chin", false, -0.06), new Person("Madison", "Barbashov", true, 89.76), new Person("Ryan", "Beatty", false, 123.5), new Person("Hailey", "Giles", false, 90.56), new Person("Molly", "Vos", true, -87.12), new Person("Nolan", "Antonio", false, 992.12), new Person("Bryce", "Marinacci", false, 1832.29), new Person("Maria", "Mayhew", true, -782.12), new Person("Lauren", "Holt", false, 291.21)});
    }
}

