/*
 * Decompiled with CFR 0.152.
 */
package samples;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.jonathangiles.hacking.tableview.cellSpan.CellSpan;
import net.jonathangiles.hacking.tableview.cellSpan.CellSpanTableView;
import net.jonathangiles.hacking.tableview.cellSpan.SpanModel;
import samples.misc.Person;

public class CellSpanTableViewSample
extends Application {
    public static void main(String[] args) {
        CellSpanTableViewSample.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("CellSpanTableView!");
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab standardTableViewTab = new Tab("Standard");
        this.buildStandardTableViewTab(standardTableViewTab);
        tabPane.getTabs().add((Object)standardTableViewTab);
        Tab rowSpanTableViewTab = new Tab("Row Span");
        this.buildRowSpanTableViewTab(rowSpanTableViewTab);
        tabPane.getTabs().add((Object)rowSpanTableViewTab);
        Tab columnSpanTableViewTab = new Tab("Column Span");
        this.buildColumnSpanTableViewTab(columnSpanTableViewTab);
        tabPane.getTabs().add((Object)columnSpanTableViewTab);
        Tab rowAndColumnSpanTableViewTab = new Tab("Row/Column Span");
        this.buildRowAndColumnSpanTableViewTab(rowAndColumnSpanTableViewTab);
        tabPane.getTabs().add((Object)rowAndColumnSpanTableViewTab);
        StackPane root = new StackPane();
        root.getChildren().add((Object)tabPane);
        Scene scene = new Scene((Parent)root, 520.0, 600.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private TableView buildBasicTableView(boolean enableCellSpan) {
        TableColumn firstNameCol = new TableColumn("First Name");
        firstNameCol.setPrefWidth(120.0);
        firstNameCol.setCellValueFactory((Callback)new PropertyValueFactory("firstName"));
        TableColumn lastNameCol = new TableColumn("Last Name");
        lastNameCol.setPrefWidth(120.0);
        lastNameCol.setCellValueFactory((Callback)new PropertyValueFactory("lastName"));
        TableColumn balanceCol = new TableColumn("Balance");
        balanceCol.setPrefWidth(120.0);
        balanceCol.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
        CellSpanTableView tableView = enableCellSpan ? new CellSpanTableView() : new TableView();
        tableView.getColumns().addAll((Object[])new TableColumn[]{firstNameCol, lastNameCol, balanceCol});
        tableView.setItems(Person.getTestList());
        final TableView.TableViewSelectionModel sm = tableView.getSelectionModel();
        sm.getSelectedCells().addListener((ListChangeListener)new ListChangeListener<TablePosition>(){

            public void onChanged(ListChangeListener.Change<? extends TablePosition> change) {
                if (!sm.getSelectedCells().isEmpty()) {
                    TablePosition tp = (TablePosition)sm.getSelectedCells().get(0);
                    if (tp == null) {
                        return;
                    }
                    System.out.println("Selection: [ row: " + tp.getRow() + ", column: " + tp.getColumn() + ", column name: " + tp.getTableColumn().getText() + " ] ");
                }
            }
        });
        return tableView;
    }

    private BorderPane buildBorderPane(Tab tab) {
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        tab.setContent((Node)pane);
        return pane;
    }

    private void buildStandardTableViewTab(Tab tab) {
        BorderPane pane = this.buildBorderPane(tab);
        TableView tableView = this.buildBasicTableView(false);
        pane.setCenter((Node)tableView);
        pane.setRight((Node)this.buildCommonControlGrid(tableView));
    }

    private void buildRowSpanTableViewTab(Tab tab) {
        BorderPane pane = this.buildBorderPane(tab);
        CellSpanTableView tableView = (CellSpanTableView)this.buildBasicTableView(true);
        pane.setCenter((Node)tableView);
        tableView.setSpanModel(new SpanModel(){
            private final CellSpan spanTwoRows = new CellSpan(2, 1);

            @Override
            public CellSpan getCellSpanAt(int rowIndex, int columnIndex) {
                return rowIndex % 3 == 0 && columnIndex == 1 ? this.spanTwoRows : null;
            }

            @Override
            public boolean isCellSpanEnabled() {
                return true;
            }
        });
        pane.setRight((Node)this.buildCommonControlGrid(tableView));
    }

    private void buildColumnSpanTableViewTab(Tab tab) {
        BorderPane pane = this.buildBorderPane(tab);
        CellSpanTableView tableView = (CellSpanTableView)this.buildBasicTableView(true);
        pane.setCenter((Node)tableView);
        tableView.setSpanModel(new SpanModel(){
            private final CellSpan spanTwoColumns = new CellSpan(1, 2);

            @Override
            public CellSpan getCellSpanAt(int rowIndex, int columnIndex) {
                return rowIndex % 2 == 0 && columnIndex == 0 ? this.spanTwoColumns : null;
            }

            @Override
            public boolean isCellSpanEnabled() {
                return true;
            }
        });
        pane.setRight((Node)this.buildCommonControlGrid(tableView));
    }

    private void buildRowAndColumnSpanTableViewTab(Tab tab) {
        BorderPane pane = this.buildBorderPane(tab);
        CellSpanTableView tableView = (CellSpanTableView)this.buildBasicTableView(true);
        pane.setCenter((Node)tableView);
        tableView.setSpanModel(new SpanModel(){
            private final CellSpan spanTwoRowsAndTwoColumns = new CellSpan(2, 2);

            @Override
            public CellSpan getCellSpanAt(int rowIndex, int columnIndex) {
                return rowIndex % 3 == 0 && columnIndex == 0 ? this.spanTwoRowsAndTwoColumns : null;
            }

            @Override
            public boolean isCellSpanEnabled() {
                return true;
            }
        });
        pane.setRight((Node)this.buildCommonControlGrid(tableView));
    }

    private GridPane buildCommonControlGrid(final TableView tableView) {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ChoiceBox rowOrCellSelectionBox = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"Row-based", "Cell-based"}));
        rowOrCellSelectionBox.getSelectionModel().select(0);
        rowOrCellSelectionBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String t, String t1) {
                if ("Row-based".equals(t1)) {
                    tableView.getSelectionModel().setCellSelectionEnabled(false);
                } else if ("Cell-based".equals(t1)) {
                    tableView.getSelectionModel().setCellSelectionEnabled(true);
                }
            }
        });
        ChoiceBox selectionModeBox = new ChoiceBox(FXCollections.observableArrayList((Object[])SelectionMode.values()));
        selectionModeBox.getSelectionModel().select((Object)SelectionMode.SINGLE);
        selectionModeBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<SelectionMode>(){

            public void changed(ObservableValue ov, SelectionMode t, SelectionMode t1) {
                tableView.getSelectionModel().setSelectionMode(t1);
            }
        });
        grid.add((Node)new Label("Selection Mode:"), 1, 1);
        grid.add((Node)rowOrCellSelectionBox, 1, 2);
        grid.add((Node)selectionModeBox, 1, 3);
        return grid;
    }
}

